NON_VEG = 0; UNBURNT_VEG = 1; BURNING_VEG = 2; BURNT_VEG = 3

L = 50 # size of landscape will be L*L
p_veg = 0.5 # initial fraction vegetated
f = 0.3 # probability of fire spread
s = 0.05 # probability of fire burning out

# initialise landscape with p_veg vegetated
M = matrix(NON_VEG,L,L)
iii = sample(length(M),round(length(M)*p_veg))
M[iii] = UNBURNT_VEG
M[iii[1]] = BURNING_VEG # ignite one cell
n_burning = 1

# loop until the fire is extinguished
while ( n_burning > 0 )
  {
  # determine to which cells fire will spread
  K = sum_Moore(M==BURNING_VEG)
  iii = which(K>0 & M==UNBURNT_VEG)
  n_can_burn = length(iii)
  do_spread = (runif(n_can_burn) < 1-(1-f)^K[iii])
  M[iii[do_spread]] = BURNING_VEG
  
  # determine which cells will burn out
  jjj = which(M==BURNING_VEG)
  n_burning = length(jjj)
  do_burn_out = (runif(n_burning) < s)
  M[jjj[do_burn_out]] = BURNT_VEG
  }

image(1:L,1:L,M,xlab='x',ylab='y') 
